// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for decrypting a file.
//..................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "sha2.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	BOOL				bIsWin95;
extern	HINSTANCE			hInst;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpKeyRingIcon;
extern	TCHAR				szPassPhrase1[250];
extern	LPCTSTR				lpszNullString;
extern	LPTSTR				lpszNA;
extern	LPCTSTR				lpIconPointer;
extern	BOOL				bProcessInProgress;
extern	HWND				hMainWindow;
extern	int					iSkipCounter;
extern	int					iInitialSkipValue;
extern	BOOL				bCancelOperation;
extern	TCHAR				szDestination[MAX_PATH];
extern	LPBYTE				lpKeyBuffer1;
extern	LPBYTE				lpKeyBuffer2;
extern	LPBYTE				lpKeyBuffer3;
extern	BYTE				KeySID;
extern	HANDLE				hIdxHandle1;
extern	HANDLE				hIdxHandle2;
extern	SEARCH_TEMPLATE		KeyIdSearch;
extern	LPBYTE				lpIndexFile1;
extern	LPBYTE				lpIndexFile2;
extern	DWORD				dwIdxOffset1;
extern	DWORD				dwIdxOffset2;
extern	LPBYTE				lpRingFile1;
extern	LPBYTE				lpFileName;
extern	HICON				hIcon;
extern	BYTE				TempUserId[256];
extern	BYTE				Temp9[MAX_MOD_SLOP];
extern	DWORD				dwN_Bytes;
extern	DWORD				dwN_Bits;
extern	DWORD				dwE_Bytes;
extern	BYTE				E_Temp[MAX_MOD_SLOP];
extern	BYTE				Modulus_N[MAX_MOD_SLOP];
extern	HANDLE				hDialogModeLess;
extern	HANDLE				hDlgCurrent;
extern	HHOOK				hHook;
extern	HHOOK				hMouseHook;
extern	BYTE				Prime_P[MAX_PRIME_SLOP];
extern	BYTE				Prime_Q[MAX_PRIME_SLOP];
extern	BYTE				Temp1[MAX_MOD_SLOP*2];
extern	BYTE				Temp2[MAX_MOD_SLOP*2];
extern	BYTE				Temp6[MAX_MOD_SLOP*2];
extern	BYTE				U_Temp[MAX_MOD_SLOP];
extern	BYTE				D_Temp[MAX_MOD_SLOP];
extern	UINT				uTimer;
extern	DWORD				dwElapHours;
extern	DWORD				dwElapMinutes;
extern	DWORD				dwElapSeconds;
extern	HWND				hStatusBar;
extern	NONREPRO_HDR		nrphdr;
extern	NONREPRO_PADHDR		nrppadhdr;
extern	BYTE				rphdr[MAX_REPRO_LGTH];
extern	FILE_INFO_PCKT		fip;
extern	DWORD				dwReproLength;
extern	DWORD				dwCountBytes;
extern	LPBYTE				lpCsumOffset;
extern	LPBYTE				lpSeedOffset;
extern	DWORD				dwRngsUsed;
extern	BYTE				RingMask;
extern	DWORD				TopsArray[256];
extern	DWORD				FactorArray[256];
extern	DWORD				SeedsArray[256];
extern	BYTE				LastSeed;
extern	DWORD				DbleNumber;
extern	DWORD				Divisor1;
extern	DWORD				Seed;
extern	LPTSTR				lpszDateTimeFormat;
extern	LPTSTR				lpszSizeFormat;
extern	NUMBERFMT			nFormatInfo;
extern	BOOL				bDisplayRingsOnStatusBar;
extern	TCHAR				szStatusBarRings[127];
extern	SHFILEINFO			shfi1;
extern	DWORD				dwUseSessionKey;
extern	BOOL				bWipeOTPFileAfterUse;
extern	BOOL				bWipeTrueOTPFileAfterUse;
extern	BOOL				bUseNew;
extern	BOOL				bUseMd5;
extern	TCHAR				szFileName[MAX_PATH];
extern	HANDLE				hInputFile;
extern	BOOL				bIntermediatePkd;
extern	BOOL				bWipeIntermediate;
extern	TCHAR				szPreviousDestinationDir[MAX_PATH];
extern	LPBYTE				lpKeyBufferDup1;
extern	LPBYTE				lpKeyBufferDup2;
extern	HFONT				hDlgFont;
extern	BOOL				bWin2000OrGreater;
extern	LPTSTR				lpClassifications[];
extern	HANDLE				hSpecialInst;
extern	CONFIG				cfg;
extern	DWORD				dwStringSafeFlag;

// Variables to be used by the decipher process.
//..............................................
TCHAR				szFileToDecipher[MAX_PATH];
TCHAR				szOtpKeyFile[MAX_PATH];
LPBYTE				lpDecryptedFileName;
LPBYTE				lpDestExtension;
ULARGE_INTEGER		uliCkeBytes;
LPCTSTR				lpszSender = "Sender: %s       Key ID: %X";
DWORD				dwSigBits;
BOOL				bWipeAfterDecryption;
BOOL				bWeHaveSha;
BOOL				bWeHaveSha512;
COLORREF			crClassification;

// Decrypt a file.
//................
BOOL DecryptAFile(LPBYTE lpDecryptFile)
{
	LARGE_INTEGER	li;
	LARGE_INTEGER	liSkeTimestamp;
	LARGE_INTEGER	liPublicKeyExpire;
	ULARGE_INTEGER	uliFreeCallerBytes;
	ULARGE_INTEGER	uliTotalBytes;
	LARGE_INTEGER	liStartPosition;
	LARGE_INTEGER	liWipeLength;
	LARGE_INTEGER	liPadFreeBytes;
	OPENFILENAME	ofn;
	LPBYTE			lpTempEDI;
	LPBYTE			lpRsaInteger;
	LPBYTE			lpOtpFileName;
	LPBYTE			lpMd5AppendPtr;
	LPBYTE			lpMd5_2_Ptr;
	DWORD			dwRsaIntegerBits;
	DWORD			dwRsaIntegerBytes;
	DWORD			dwOldHelpTopic;
	DWORD			dwLastError;
	DWORD			dwBytesWritten;
	DWORD			dwMd5AppendLength;
	int				iMd5Passed = -2;
	HANDLE			hFileToDecipher = 0;
	HANDLE			hOtpKeyFile = 0;
	HANDLE			hDecryptedFile = 0;
	DWORD			dwBytesToRead;
	DWORD			dwBytesRead;
	DWORD			dwIdLength;
	DWORD			dwTempECX;
	DWORD			dwCtb_Byte;
	DWORD			dwCheckSum;
	DWORD			dwHdrCheckSum;
	BOOL			bResult;
	BOOL			bDeleteDecryptedFile = TRUE;
	int				iResult;
	HRESULT			hr = ERROR_SUCCESS;
	DWORD			dwResult;
	BOOL			bError = TRUE;
	BOOL			bErr = TRUE;
	DWORD			dwPubKeyID;
	BOOL			bWeHaveAMatch = FALSE;
	BYTE			CtbByte;
	TCHAR			szFormat[128];
	TCHAR			szOutBuffer[512];
	BROWSEINFO		bi;
    LPITEMIDLIST	lpidl;
    LPMALLOC		lpMalloc;
	TCHAR			szRoot[16];
	BYTE			Md5ForFile[MD5_DIGEST_SIZE];
	BYTE			ShaForFile[SHA_DIGEST_SIZE];
	BYTE			Sha512ForFile[SHA512_DIGEST_SIZE];
	DWORD			dwPathLength;
	UINT			uiMd5Result;
	BYTE			TempByte;
	DWORD			dwTypeDigest;
	int				i;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	dwOldHelpTopic = ChangeHelpTopic(IDH_DECIPHER);
	bWipeAfterDecryption = FALSE;
	bWipeIntermediate = TRUE;
	bWeHaveSha = FALSE;
	bWeHaveSha512 = FALSE;

	// Setup the skip counters for the CheckForMessages function.
	//...........................................................
	__asm
	{
		mov		iSkipCounter,250
		mov		iInitialSkipValue,250
	}
	// Clear all the variables we will be using.
	//..........................................
	ClearAllVariables();
	ClearMathVariables();

	// Setup the key rings.
	//.....................
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_ONE);
	SetUpGroup(SECRET_KEY,INDEX_KEY,GROUP_TWO);

	if (BPC())
	{
		goto DecipherEnd;
	}
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	if (!lpDecryptFile)
	{
		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = szFileToDecipher;
		ofn.nMaxFile = sizeof(szFileToDecipher);
		ofn.hwndOwner = hMainWindow;
		ofn.hInstance = hInst;
		ofn.lpstrFilter = TEXT("Tscg Encrypted Files [.tsc]\0*.tsc\0All Files [*.*]\0*.*\0");
		ofn.nFilterIndex = 1;
		ofn.lpstrTitle = TEXT("Select a File to Decipher");
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
			         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
					 OFN_SHOWHELP | OFN_ENABLETEMPLATE);
		ofn.lpstrDefExt = NULL;
		if (bWin2000OrGreater)
		{
			ofn.lpTemplateName = TEXT("WIPEAFTERDECRYPTINGNEW");
		}
		else
		{
			ofn.lpTemplateName = TEXT("WIPEAFTERDECRYPTING");
		}
		ofn.lpfnHook = MyDecOFNHookProc;

		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		while(TRUE)
		{
			// Now select a file to decipher.
			//...............................
			ZeroMemory(&szFileToDecipher,sizeof(szFileToDecipher));

			if (!GetOpenFileName(&ofn))
			{
				CommDlgBoxErrorProc(IDS_GET_FILES);
				goto DecipherEnd;
			}
			// Save the dir name.
			//...................
			SaveDirName((LPBYTE)&szFileToDecipher,SAVE_SOURCE,TRUE);

			// Check out the file. It has to be a valid tsc encrypted file.
			//.............................................................
			li.QuadPart = IsTscFileValid((LPBYTE)&szFileToDecipher);

			if (li.QuadPart == -1)
			{
				SetLastError(IDS_NOTVALIDTSCFILE);
				ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_CREATE_OPEN,MB_OK);
			}
			else
			{
				break;
			}
		}
	}
	// Get a pointer to the file name.
	//................................
	lpFileName = PathFindFileName((LPCTSTR)szFileToDecipher);

	// Allocate memory for the buffers we will use.
	//.............................................
	lpKeyBuffer1 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer2 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer3 = AllocateMemory(SIZE_KEY_BUFF);

	if (!lpKeyBuffer1 || !lpKeyBuffer2 || !lpKeyBuffer3)
	{
		goto DecipherEnd;
	}
	// The first thing we have to do is look on our secret key ring
	// to see if we have a match against a pke packet in the file
	// so we can decipher it.
	//.............................................................
	hFileToDecipher = CreateMyFile((LPTSTR)&szFileToDecipher,GENERIC_READ,0,NULL,OPEN_EXISTING,
								    FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFileToDecipher)
	{
		goto DecipherEnd;
	}
	while(TRUE)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
		bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
							  lpKeyBuffer1,1,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecipherEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		__asm
		{
			mov		edi,lpKeyBuffer1
			mov		al,byte ptr [edi]
			mov		cl,al
			and		al,CTB_MASK
			mov		CtbByte,al
			mov		dwTempECX,ecx
		}
		if (CtbByte != CTB_PKE_PACKET)
		{
			break;
		}
		__asm
		{
			mov		edx,1
			mov		ecx,dwTempECX
			and		ecx,LENGTH_MASK
			shl		edx,cl
			mov		dwBytesToRead,edx
		}
		bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
							  lpKeyBuffer1,dwBytesToRead,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecipherEnd;
		}
		// Get the length of this packet.
		//...............................
		__asm
		{
			mov		edi,lpKeyBuffer1
			cmp		dwBytesToRead,1
			jne		L1
			movzx	eax,byte ptr [edi]
			jmp		L3
		L1:	cmp		dwBytesToRead,2
			jne		L2
			movzx	eax,word ptr [edi]
			xchg	ah,al
			jmp		L3
		L2:	mov		eax,dword ptr [edi]
			bswap	eax
		L3: mov		dwBytesToRead,eax
		}
		// Read in the packet which will leave the file pointer
		// pointing to the ctb byte of the next packet.
		//.....................................................
		bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
							  lpKeyBuffer1,dwBytesToRead,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecipherEnd;
		}
		// Check out the pke packet and see if it belongs to us.
		//......................................................
		__asm
		{
			mov		edi,lpKeyBuffer1
			add		edi,VERSION_SIZE
			mov		eax,dword ptr [edi]
			mov		edx,dword ptr [edi+4]
			mov		dword ptr KeySID,eax
			mov		dword ptr KeySID[4],edx
			add		edi,KEY_ID_SIZE
			mov		lpTempEDI,edi
		}
		// If this is not a rsa encrypted packet, we can't
		// handle it. Try the next one.
		//................................................
		if (*lpTempEDI != RSA_ALGORITHM)
		{
			continue;
		}
		// Get the mpi of the rsa encrypted integer.
		//..........................................
		__asm
		{
			mov		edi,lpTempEDI
			add		edi,ALGORITHM_SIZE
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			xchg	ah,al
			mov		dwRsaIntegerBits,eax
			mov		lpRsaInteger,edi
			add		eax,7
			shr		eax,3
			mov		dwRsaIntegerBytes,eax
		}
		// Skip this pke packet if the rsa integer is not a size
		// we can handle.
		//......................................................
		if (dwRsaIntegerBits > MAX_BITS)
		{
			continue;
		}
		// See if we have a match on our secret key ring.
		//...............................................
		li.QuadPart = SearchMyFileBinary(lpIndexFile2,&KeySID,KEY_ID_SIZE,hIdxHandle2,
										 0,&KeyIdSearch);
		if (li.QuadPart == -1)
		{
			goto DecipherEnd;
		}
		if (li.QuadPart != 0)
		{
			bWeHaveAMatch = TRUE;
			break;
		}
	}
	// If we do not have a match, say so.
	//...................................
	if (!bWeHaveAMatch)
	{
		LoadString(hInst,IDS_CANTDECIPHER,(LPTSTR)&szFormat,sizeof(szFormat));
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFormat,
					    szFileToDecipher);
		MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szOutBuffer,
					   MB_OK | MB_ICONHAND,MB_ICONHAND,0);
		goto DecipherEnd;
	}
	// We have a match. Get the secret key into lpKeyBuffer2.
	//.......................................................
	dwIdxOffset2 = li.HighPart;
	dwBytesRead = ReadIndex2();
	if (dwBytesRead == -1)
	{
		goto DecipherEnd;
	}
	dwBytesRead = ReadRecord2();
	if (dwBytesRead == -1)
	{
		goto DecipherEnd;
	}

	EmptyTheMessageQue();

	// Get a destination drive and directory for the deciphered file.
	//...............................................................
	if (!lpDecryptFile)
	{
		while(TRUE)
		{
			SetCurrentDirectory((LPCTSTR)&szPreviousDestinationDir);
			ZeroMemory(&szDestination,sizeof(szDestination));

			if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
			{
				ZeroMemory(&bi,sizeof(bi));
				bi.hwndOwner = hMainWindow;
				bi.pszDisplayName = 0;
				bi.lpszTitle = TEXT("Select a Destination for the Decrypted File.");
				bi.pidlRoot = 0;
				bi.ulFlags = BIF_RETURNONLYFSDIRS;

				// If we can use the new style of the dialog box, do it.
				//......................................................
				if (bUseNew)
				{
					hr = CoInitialize(NULL);
					if (SUCCEEDED(hr))
					{
						bi.ulFlags |= BIF_NEWDIALOGSTYLE;
					}
				}
				bi.lpfn = BrowseCallbackProc;

				lpidl = SHBrowseForFolder(&bi);

				if (bUseNew && SUCCEEDED(hr))
				{
					CoUninitialize();
				}
				if (lpidl) 
				{
					bResult = SHGetPathFromIDList(lpidl,(LPSTR)&szDestination);
					lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
					lpMalloc->lpVtbl->Release(lpMalloc);
				}
				else
				{
					// We cancelled out.
					//..................
					goto DecipherEnd;
				}
				// Save the dir name.
				//...................
				SaveDirName((LPBYTE)&szDestination,SAVE_DESTINATION,FALSE);

				// See if we have any free disk space. cd rom drives that
				// are not writable will report zero.
				//.......................................................
				ZeroMemory(&szRoot,sizeof(szRoot));
				CopyMemory(&szRoot,&szDestination,3);
				bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
										    (PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
										    (PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
				if (!bResult)
				{
					ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
					goto DecipherEnd;
				}
				if (uliFreeCallerBytes.QuadPart == 0)
				{
					SetLastError(IDS_NOSPACE);
					ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
					continue;
				}
				// Make sure that the destination and file name fit
				// into a file specification.
				//.................................................
				PathAddBackslash((LPTSTR)&szDestination);
				dwPathLength = lstrlen((LPCTSTR)&szDestination) + 
							   lstrlen((LPCTSTR)lpFileName) + 1;
				if (dwPathLength > MAX_PATH)
				{
					SetLastError(IDS_PATHTOOLONG);
					ErrorProcedure((LPTSTR)&szDestination,IDS_BROWSEFORFOLDER,MB_OK);
					continue;
				}
				// If we got this far with no error, we have a valid
				// destination.
				//..................................................
				break;
			}
			else
			{
				MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
							   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				goto DecipherEnd;
			}
		}
	}
	// Search for the first user id in the secret key. We may need it.
	//................................................................
	ZeroMemory(&TempUserId,sizeof(TempUserId));
	lpKeyBufferDup2 = lpKeyBuffer2;
	while(TRUE)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup2
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		CtbByte,al
		}
		if (CtbByte != CTB_USER_ID)
		{
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup2,edi
			}
		}
		else
		{
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpKeyBufferDup2,edi
				mov		dwIdLength,eax
			}
			break;
		}
	}
	CopyMemory(&TempUserId,lpKeyBufferDup2,dwIdLength);

	// Setup for decrypting the pke packet which holds
	// information about the true one time pad file, the
	// otp key file, or the random session key.
	//..................................................
	iResult = SignSetup(lpKeyBuffer2,IDS_NODECIPHER,IDS_INVALIDDECPP);
	if (iResult != 1)
	{
		goto DecipherEnd;
	}
	// Setup the rsa integer we have to decrypt.
	//..........................................
	CopyMemory(&Temp9,lpRsaInteger,dwRsaIntegerBytes);
	CircleSwap((LPBYTE)&Temp9,dwRsaIntegerBytes);

	// The number of bits in the rsa integer must be less than
	// or equal to the number of bits in modulus n in the 
	// Secret Key.
	//........................................................
	if (dwRsaIntegerBits > dwN_Bits)
	{
	  InvalidRsaInteger:
		SetLastError(IDS_RSAINTEGERGTEMODULUSN);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherEnd;
	}
	// If the number of bits are equal, do an actual comparision to
	// make sure the rsa integer is less than modulus n.
	//.............................................................
	if (dwRsaIntegerBits == dwN_Bits)
	{
		dwResult = MpCompareDW((LPBYTE)&Modulus_N,(LPBYTE)&Temp9,MAX_MOD_DWORD);
		if (dwResult ==	0 || dwResult == 1)
		{
			goto InvalidRsaInteger;
		}
	}
	// Setup our elapsed timer.
	//.........................
	dwElapHours = 0;
	dwElapMinutes = 0;
	dwElapSeconds = 0;
	uTimer = SetTimer(hMainWindow,MY_TIMER,1000,(TIMERPROC)My1SecondTimer);

	DisplayZeroTimer();
	EmptyTheMessageQue();

	// Decrypt our pke packet.
	//........................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("DECRYPTPKEPACKET"),hMainWindow,
								  (DLGPROC)DecryptPkePacketProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto DecipherEnd;
	}
	bError = RsaPriDec((LPBYTE)&Temp6,(LPBYTE)&Temp9,(LPBYTE)&D_Temp,
					  (LPBYTE)&Prime_P,(LPBYTE)&Prime_Q,(LPBYTE)&U_Temp,dwN_Bytes);

	DestroyWindow(hDialogModeLess);

	EmptyTheMessageQue();

	if (bCancelOperation == TRUE)
	{
		goto DecipherEnd;
	}
	// Check to see if we had an error.
	//.................................
	if (bError)
	{
		SetLastError(IDS_RSAPRIVATEDECRYPTERROR);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherEnd;
	}
	// Check if the file was encrypted with an OTP Key File or 
	// a random session key.
	//........................................................
	if (dwCountBytes == sizeof(NONREPRO_HDR))
	{
		CopyMemory(&nrphdr,&Temp6,dwCountBytes);
		dwUseSessionKey = USE_KEY;
	}
	else if (dwCountBytes == sizeof(NONREPRO_PADHDR))
	{
		CopyMemory(&nrppadhdr,&Temp6,dwCountBytes);
		dwUseSessionKey = USE_PAD;
	}
	else if (dwCountBytes == KEY_4_LGTH || dwCountBytes == KEY_8_LGTH ||
			 dwCountBytes == KEY_16_LGTH || dwCountBytes == KEY_32_LGTH ||
			 dwCountBytes == KEY_64_LGTH || dwCountBytes == KEY_128_LGTH)
	{
		dwReproLength = dwCountBytes;
		CopyMemory(&rphdr,&Temp6,dwCountBytes);
		dwUseSessionKey = USE_RANDOM;
	}
	else
	{
		// We have a key length we cannot deal with.
		//..........................................
		SetLastError(IDS_INVALIDKEYLENGTH);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherEnd;
	}
	// Check out the checksum to make sure it is correct.
	//...................................................
	if (dwUseSessionKey == USE_RANDOM)
	{
		lpCsumOffset = (LPBYTE)&rphdr;
		lpSeedOffset = (LPBYTE)&rphdr;

		dwRngsUsed = RNGS_128;

		if (dwReproLength == KEY_4_LGTH)
		{
			dwRngsUsed = RNGS_4;
		}
		else if (dwReproLength == KEY_8_LGTH)
		{
			dwRngsUsed = RNGS_8;
		}
		else if (dwReproLength == KEY_16_LGTH)
		{
			dwRngsUsed = RNGS_16;
		}
		else if (dwReproLength == KEY_32_LGTH)
		{
			dwRngsUsed = RNGS_32;
		}
		else if (dwReproLength == KEY_64_LGTH)
		{
			dwRngsUsed = RNGS_64;
		}
		lpCsumOffset += (dwReproLength - SIZE_OF_CSUM);
		lpSeedOffset += (dwReproLength - SIZE_OF_CSUM - SIZE_OF_SEED);

		__asm
		{
			mov		eax,dwRngsUsed
			mov		RingMask,al
			dec		RingMask
		}
		// Calculate and check the checksum of the header.
		//................................................
		__asm
		{
			mov		esi,lpCsumOffset
			movzx	eax,word ptr [esi]
			xchg	ah,al
			mov		dwHdrCheckSum,eax
		}
		dwCheckSum = CheckSum((LPBYTE)&rphdr,(dwReproLength - SIZE_OF_CSUM));
		if (dwHdrCheckSum != dwCheckSum)
		{
			SetLastError(IDS_PKECSUMINVALID);
			ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
			goto DecipherEnd;
		}
		__asm
		{
			mov		esi,lpSeedOffset
			mov		eax,dword ptr [edi]
			mov		Seed,eax
		}
	}
	else if (dwUseSessionKey == USE_KEY)
	{
		__asm
		{
			movzx	eax,nrphdr.CHECKSUM
			xchg	ah,al
			mov		dwHdrCheckSum,eax
		}
		dwCheckSum = CheckSum((LPBYTE)&nrphdr,sizeof(nrphdr) - 2);
		if (dwHdrCheckSum != dwCheckSum)
		{
			SetLastError(IDS_PKECSUMINVALID);
			ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
			goto DecipherEnd;
		}
		Seed = nrphdr.INITIAL_SEED;
		RingMask = -1;
	}
	else
	{
		__asm
		{
			movzx	eax,nrppadhdr.CHECKSUM
			xchg	ah,al
			mov		dwHdrCheckSum,eax
		}
		dwCheckSum = CheckSum((LPBYTE)&nrppadhdr,sizeof(nrppadhdr) - 2);
		if (dwHdrCheckSum != dwCheckSum)
		{
			SetLastError(IDS_PKECSUMINVALID);
			ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
			goto DecipherEnd;
		}
	}
	// Read in the ske packet and file info packet. Use lpKeyBuffer2
	// for the ske packet. First we have to get past any remaining
	// pke packets.
	//..............................................................
	while(TRUE)
	{
		bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
							 lpKeyBuffer2,1,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecipherEnd;
		}
		__asm
		{
			mov		edi,lpKeyBuffer2
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		CtbByte,al
		}
		if (CtbByte != CTB_PKE_PACKET)
		{
			break;
		}
		__asm
		{
			mov		edx,1
			mov		ecx,dwCtb_Byte
			and		ecx,LENGTH_MASK
			shl		edx,cl
			mov		dwBytesToRead,edx
		}
		bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
							  lpKeyBuffer2,dwBytesToRead,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecipherEnd;
		}
		// Get the length of this packet.
		//...............................
		__asm
		{
			mov		edi,lpKeyBuffer2
			cmp		dwBytesRead,1
			jne		L5
			movzx	ecx,byte ptr [edi]
			jmp		L7
		L5:	cmp		dwBytesRead,2
			jne		L6
			movzx	eax,word ptr [edi]
			xchg	ah,al
			jmp		L7
		L6:	mov		eax,dword ptr [edi]
			bswap	eax
		L7:	mov		dwBytesToRead,eax
		}
		// Read in the packet which will leave the file pointer
		// pointing to the ctb byte of the next packet.
		//.....................................................
		bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
							  lpKeyBuffer2,dwBytesToRead,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecipherEnd;
		}
	}
	// This packet should be the ske packet. If not, bail out.
	//........................................................
	if (CtbByte != CTB_SKE_PACKET)
	{
		SetLastError(IDS_SKEOUTOFORDER);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherEnd;
	}
	// Get the length of the length field.
	//....................................
	__asm
	{
		mov		edx,1
		mov		ecx,dwCtb_Byte
		and		ecx,LENGTH_MASK
		shl		edx,cl
		mov		dwBytesToRead,edx
	}
	bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
						  lpKeyBuffer2,dwBytesToRead,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto DecipherEnd;
	}
	// Get the length of the ske packet.
	//..................................
	__asm
	{
		mov		edi,lpKeyBuffer2
		cmp		dwBytesRead,1
		jne		L8
		movzx	eax,byte ptr [edi]
		jmp		L10
	L8:	cmp		dwBytesRead,2
		jne		L9
		movzx	eax,word ptr [edi]
		xchg	ah,al
		jmp		L10
	L9:	mov		eax,dword ptr [edi]
		bswap	eax
   L10:	mov		dwBytesToRead,eax
	}
	// Read in the packet which will leave the file pointer pointing
	// to the ctb byte of the next packet which should be the file
	// info packet.
	//..............................................................
	bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
						  lpKeyBuffer2,dwBytesToRead,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto DecipherEnd;
	}
	// Look at the ske packed to determine if we have a Md5, Sha1 or Sha512 message digest.
	//.....................................................................................
	if (*(lpKeyBuffer2 + 1) == SKE_SHA_APPEND_LGTH)
	{
		bWeHaveSha = TRUE;
	}
	if (bWeHaveSha)
	{
		if (*(lpKeyBuffer2 + 16) == SHA512_ALGORITHM)
		{
			bWeHaveSha512 = TRUE;
		}
	}
	// Let's get the file info packet into memory in lpKeyBuffer1.
	//............................................................
	bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
						  lpKeyBuffer1,1,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto DecipherEnd;
	}
	// Make sure it is the file info packet.
	//......................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		mov		al,byte ptr [edi]
		mov		cl,al
		mov		dwCtb_Byte,ecx
		and		al,CTB_MASK
		mov		CtbByte,al
	}
	if (CtbByte != CTB_FILE_INFO)
	{
		SetLastError(IDS_FIPOUTOFORDER);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherEnd;
	}
	// Get the length of the length field.
	//....................................
	__asm
	{
		mov		edx,1
		mov		ecx,dwCtb_Byte
		and		ecx,LENGTH_MASK
		shl		edx,cl
		mov		dwBytesToRead,edx
	}
	bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
						  lpKeyBuffer1,dwBytesToRead,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto DecipherEnd;
	}
	// Get the length of the file info packet.
	//........................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		cmp		dwBytesRead,1
		jne		L11
		movzx	eax,byte ptr [edi]
		jmp		L13
   L11:	cmp		dwBytesRead,2
		jne		L12
		movzx	eax,word ptr [edi]
		xchg	ah,al
		jmp		L13
   L12: mov		eax,dword ptr [edi]
		bswap	eax
   L13:	mov		dwBytesToRead,eax
	}
	if (dwBytesToRead != (sizeof(FILE_INFO_PCKT) - 3))
	{
		SetLastError(IDS_FIPINVALIDLENGTH);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherEnd;
	}
	// Read in the file information packet and leave the file pointer
	// pointing to the cke packet.
	//...............................................................
	bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
						  &fip.FILE_NAME,dwBytesToRead,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto DecipherEnd;
	}

	EmptyTheMessageQue();

	// See if we have a true one time pad or otp file to select.
	//..........................................................
	if (dwUseSessionKey != USE_RANDOM)
	{
		FlashMyIcon(TRUE);

		// Go into a loop until we select the correct otp key file
		// or cancel.
		//........................................................
		while(TRUE)
		{
			// Initialize the OPENFILENAME structure.
			//.......................................
			if (dwUseSessionKey == USE_KEY)
			{
				InitializeOFN(&ofn,SAVE_OTPKEYFILES);
			}
			else
			{
				InitializeOFN(&ofn,SAVE_TOTPFILES);
			}
			// Initialize with specific information for this procedure.
			//.........................................................
			ofn.lpstrFile = szOtpKeyFile;
			ofn.nMaxFile = sizeof(szOtpKeyFile);
			ofn.hwndOwner = hMainWindow;
			ofn.hInstance = hInst;
			ofn.nFilterIndex = 1;
			ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | 
						 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY | OFN_SHOWHELP);
			if (!cfg.dwWipeAfterUse)
			{
				ofn.Flags |= OFN_ENABLETEMPLATE;	
			}
			ofn.lpstrDefExt = NULL;

			if (dwUseSessionKey == USE_KEY)
			{
				CopyMemory(&szOtpKeyFile,&nrphdr.LONG_FILE_NAME,MAX_PATH);
				ofn.lpstrFilter = TEXT("One Time Pad Key Files [.otp]\0*.otp\0All Files [*.*]\0*.*\0");	
				ofn.lpstrTitle = TEXT("Select the Designated One Time Pad Key File");
				if (!cfg.dwWipeAfterUse)
				{
					if (bWin2000OrGreater)
					{
						ofn.lpTemplateName = TEXT("WIPEOTPKEYFILENEW");
					}
					else
					{
						ofn.lpTemplateName = TEXT("WIPEOTPKEYFILE");
					}
					ofn.lpfnHook = MyOTPOFNHookProc;
				}
				else
				{
					ofn.lpfnHook = MyOFNHookProc;
				}
			}
			else
			{
				CopyMemory(&szOtpKeyFile,&nrppadhdr.LONG_FILE_NAME,MAX_PATH);
				ofn.lpstrFilter = TEXT("True One Time Pad Files [.pad]\0*.pad\0All Files [*.*]\0*.*\0");	
				ofn.lpstrTitle = TEXT("Select the Designated True One Time Pad File");
				if (!cfg.dwWipeAfterUse)
				{
					if (bWin2000OrGreater)
					{
						ofn.lpTemplateName = TEXT("WIPETRUEOTPFILENEW");
					}
					else
					{
						ofn.lpTemplateName = TEXT("WIPETRUEOTPFILE");
					}
					ofn.lpfnHook = MyTrueOFNHookProc;
				}
				else
				{
					ofn.lpfnHook = MyOFNHookProc;
				}
			}
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;

			FlashMyIcon(FALSE);

			// Now select the designated otp key file or true one time pad file.
			//..................................................................
			if (!GetOpenFileName(&ofn))
			{
				CommDlgBoxErrorProc(IDS_GET_FILES);
				goto DecipherEnd;
			}
			// Setup a pointer to the file name in the path.
			//..............................................
			lpOtpFileName = PathFindFileName((LPCTSTR)&szOtpKeyFile);

			if (dwUseSessionKey == USE_KEY)
			{
				SaveDirName((LPBYTE)&szOtpKeyFile,SAVE_OTPKEYFILES,TRUE);
			}
			else
			{
				SaveDirName((LPBYTE)&szOtpKeyFile,SAVE_TOTPFILES,TRUE);
			}
			// Make sure we selected the correct file.
			//........................................
			if (dwUseSessionKey == USE_KEY)
			{
				iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)lpOtpFileName,-1,
									   (LPCTSTR)&nrphdr.LONG_FILE_NAME,-1);
			}
			else
			{
				iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)lpOtpFileName,-1,
									   (LPCTSTR)&nrppadhdr.LONG_FILE_NAME,-1);
			}
			if (iResult != CSTR_EQUAL)
			{
				if (dwUseSessionKey == USE_KEY)
				{
					SetLastError(IDS_WRONGOTPKEYFILE);
				}
				else
				{
					SetLastError(IDS_WRONGTRUEONETIMEPADFILE);
				}
				ErrorProcedure((LPTSTR)&szOtpKeyFile,IDS_GET_FILES,MB_OK);
				continue;
			}
			// Make sure it is a valid otp key file or true one time pad file.
			//................................................................
			if (dwUseSessionKey == USE_KEY)
			{
				hOtpKeyFile = IsValidOTPKeyFile((LPTSTR)&szOtpKeyFile);
			}
			else
			{
				hOtpKeyFile = IsValidTruePadFile((LPTSTR)&szOtpKeyFile);
			}
			if (!hOtpKeyFile)
			{
				continue;
			}
			break;
		}
	}
	EmptyTheMessageQue();

	// Setup the random number generators.
	//....................................
	if (dwUseSessionKey == USE_RANDOM)
	{
		// Setup the factor array first, followed by the tops and
		// seeds arrays.
		//.......................................................
		__asm
		{
			mov		eax,dwRngsUsed
			mov		ecx,SIZE_OF_SEED
			mul		ecx
			mov		ecx,eax
			push	ecx
			push	ecx
			mov		esi,offset rphdr
			mov		edi,offset FactorArray
			rep		movsb
			pop		ecx
			mov		edi,offset TopsArray
			rep		movsb
			pop		ecx
			mov		edi,offset SeedsArray
			rep		movsb

			// Setup the first LastSeed value.
			//................................
			mov		al,byte ptr rphdr[12]
			and		al,RingMask
			mov		LastSeed,al

			// Setup the DbleNumber value.
			//............................
			mov		esi,lpSeedOffset
			mov		eax,dword ptr [esi-7]
			clc
			rcl		eax,1
			jnc		L14
			mov		eax,-1
	   L14:	mov		DbleNumber,eax
		}
	}
	else if (dwUseSessionKey == USE_KEY)
	{
		bResult = ReadMyFile((LPTSTR)&szOtpKeyFile,hOtpKeyFile,
							  lpKeyBuffer3,(Goal * 4),&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecipherEnd;
		}
		SetupArrays(lpKeyBuffer3);
	}
	else
	{
		li.QuadPart = nrppadhdr.ULI_STARTING_POINT.QuadPart;
		li.QuadPart = SetMyFilePointer((LPTSTR)&szOtpKeyFile,hOtpKeyFile,li.QuadPart,
									    FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto DecipherEnd;
		}
		liStartPosition.QuadPart = nrppadhdr.ULI_STARTING_POINT.QuadPart;
	}
	// Clear the session key, they are no longer needed.
	//..................................................
	ZeroMemory(&nrphdr,sizeof(NONREPRO_HDR));
	ZeroMemory(&rphdr,MAX_REPRO_LGTH);
	ZeroMemory(&nrppadhdr,sizeof(NONREPRO_PADHDR));
	Divisor1 = 256;

	// Rearange the buffers for deciphering the file. lpKeyBuffer3
	// now holds the ske packet.
	//............................................................
	CopyMemory(lpKeyBuffer3,lpKeyBuffer2,SIZE_KEY_BUFF);
	ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
	ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
	DeallocateMemory(lpKeyBuffer1);
	DeallocateMemory(lpKeyBuffer2);
	lpKeyBuffer1 = 0;
	lpKeyBuffer2 = 0;
	lpKeyBuffer1 = AllocateMemory(ENC_BUFFER_SIZE);
	if (!lpKeyBuffer1)
	{
		goto DecipherEnd;
	}
	if (dwUseSessionKey == USE_PAD)
	{
		lpKeyBuffer2 = AllocateMemory(ENC_BUFFER_SIZE);
		if (!lpKeyBuffer2)
		{
			goto DecipherEnd;
		}
	}
	// Decrypt the file information packet.
	//.....................................
	if (dwUseSessionKey == USE_PAD)
	{
		ChangeBytesPad((LPBYTE)&fip.FILE_NAME,sizeof(FILE_INFO_PCKT) - 3,hOtpKeyFile);
	}
	else
	{
		ChangeBytes((LPBYTE)&fip.FILE_NAME,sizeof(FILE_INFO_PCKT) - 3);
	}
	// Setup the destination file spec for the decrypted file.
	//........................................................
	if ((lstrlen((LPCTSTR)&szDestination) + 
		lstrlen((LPCTSTR)&fip.FILE_NAME) + 1) > MAX_PATH)
	{
		SetLastError(IDS_PATHTOOLONGDEC);
		ErrorProcedure((LPTSTR)&szDestination,IDS_CREATE_OPEN,MB_OK);
		goto DecipherEnd;
	}
	// Form the full destination specification.
	//.........................................
	StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)&fip.FILE_NAME,
				   NULL,NULL,dwStringSafeFlag);
	lpDecryptedFileName = PathFindFileName((LPCTSTR)&szDestination);
	lpDestExtension = PathFindExtension((LPCTSTR)&szDestination);

	// Display the special instructions if we have any.
	//.................................................
	if (fip.INSTRUCTION_LENGTH)
	{
		FlashMyIcon(TRUE);

		// Set the default color of black.
		//................................
		crClassification = RGB(0,0,0);

		// See if we have one of the predefined classifications.
		//......................................................
		for(i = 0; i < CLASSIFICATIONS; i++)
		{
			iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&fip.INSTRUCTIONS,
								    lstrlen((LPCTSTR)&fip.INSTRUCTIONS),
								    (LPCTSTR)lpClassifications[i],
									lstrlen((LPCTSTR)lpClassifications[i]));
			if (iResult == CSTR_EQUAL)
			{
				if (i <= 2)
				{
					crClassification = RGB(255,128,0);
				}
				else if (i == 3)
				{
					crClassification = RGB(255,0,0);
				}
				else if (i == 4)
				{
					crClassification = RGB(0,0,255);
				}
				else if (i == 5)
				{
					crClassification = RGB(128,0,128);
				}
				else if (i == 6)
				{
					crClassification = RGB(0,128,0);
				}
				break;
			}
		}
		// Get any special instructions to send to the recipients.
		//........................................................
		iResult = DialogBox(hInst,TEXT("PUTSPECIALINSTRUCTIONS"),
							hMainWindow,(DLGPROC)PutSpecialInstructionsProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto DecipherEnd;
		}
		if (iResult == IDCANCEL)
		{
			goto DecipherEnd;
		}
	}
	// Check out the cke packet.
	//..........................
	bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
						  lpKeyBuffer1,1,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto DecipherEnd;
	}
	__asm
	{
		mov		edi,lpKeyBuffer1
		mov		al,byte ptr [edi]
		mov		cl,al
		mov		dwCtb_Byte,ecx
		and		al,CTB_MASK
		mov		CtbByte,al
	}
	if (CtbByte != CTB_CKE_PCKT)
	{
		SetLastError(IDS_CKEOUTOFORDER);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherEnd;
	}
	// Determine the length of the length field and read it.
	//......................................................
	__asm
	{
		mov		edx,1
		mov		ecx,dwCtb_Byte
		and		ecx,LENGTH_MASK
		shl		edx,cl
		mov		dwBytesToRead,edx
	}
	// Read in the length field.
	//..........................
	bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
						  lpKeyBuffer1,dwBytesToRead,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto DecipherEnd;
	}
	// Get the length of this packet.
	//...............................
	uliCkeBytes.QuadPart = 0;
	uliTotalBytes.QuadPart = 0;
	__asm
	{
		mov		edi,lpKeyBuffer1
		cmp		dwBytesRead,1
		jne		L15
		movzx	eax,byte ptr [edi]
		mov		uliCkeBytes.LowPart,eax
		jmp		L18
   L15:	cmp		dwBytesRead,2
		jne		L16
		movzx	eax,word ptr [edi]
		xchg	ah,al
		mov		uliCkeBytes.LowPart,eax
		jmp		L18
   L16:	cmp		dwBytesRead,4
		jne		L17
		mov		eax,dword ptr [edi]
		bswap	eax
		mov		uliCkeBytes.LowPart,eax
		jmp		L18
   L17:
	}
	CircleSwap(lpKeyBuffer1,8);
	CopyMemory(&uliCkeBytes.QuadPart,lpKeyBuffer1,8);
	liWipeLength.QuadPart = (uliCkeBytes.QuadPart + sizeof(FILE_INFO_PCKT) - 3);

   L18:

	// Create the file to hold the deciphered file. If the file
	// already exists, ask if we want to overwrite.
	//.........................................................
	hDecryptedFile = CreateFile((LPTSTR)&szDestination,GENERIC_READ |GENERIC_WRITE,0,NULL,
								 CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);

	if (hDecryptedFile == INVALID_HANDLE_VALUE)
	{
		hDecryptedFile = 0;

		dwLastError = GetLastError();
		if (dwLastError == ERROR_FILE_EXISTS)
		{
			// Flash our task bar icon if it is minimized.
			//............................................
			FlashMyIcon(FALSE);
		
			// Ask if we want to override.
			//............................
			iResult = DialogBox(hInst,TEXT("CONFIRMOVERWRITEDEC"),hMainWindow,
							   (DLGPROC)ConfirmOverWriteDecProc);

			// See if we had a system error in creating the dialog box.
			//.........................................................
			if (iResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto DecipherEnd;
			}
			// Destroy the icon if we used it.
			//................................
			if (hIcon)
			{
				DestroyIcon(hIcon);
				hIcon = 0;
			}
			// Quit if we canceled.
			//.....................
			if (iResult == IDCANCEL)
			{
				goto DecipherEnd;
			}
			// We want to overwrite the file.
			//...............................
			hDecryptedFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,
										   0,NULL,TRUNCATE_EXISTING,FILE_ATTRIBUTE_NORMAL,
										   NULL);
			if (!hDecryptedFile)
			{
				goto DecipherEnd;
			}
		}
		else
		{
			SetLastError(dwLastError);
			ErrorProcedure((LPTSTR)&szDestination,IDS_CREATE_OPEN,MB_OK);
			goto DecipherEnd;
		}
	}
	FlashMyIcon(FALSE);

	// Setup a hook procedure to trap the tab key and mouse input.
	//............................................................
	hHook = SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)TrapTabKey,NULL,0);
	hMouseHook = SetWindowsHookEx(WH_MOUSE,(HOOKPROC)TrapMouseInput,NULL,0);

	// Display the progress information screen.
	//.........................................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("DECRYPTAFILE"),hMainWindow,
								  (DLGPROC)DecryptAFileProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto DecipherEnd;
	}
	// Enable and set decrypting file information packet since
	// we already did it.
	//.........................................................
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_ENCRYPT1),TRUE);
	Sleep(250);
	CheckDlgButton(hDialogModeLess,IDC_ENCRYPT1,BST_CHECKED);

	// Decrypt the file. Destination is already open.
	//...............................................
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_ENCRYPT2),TRUE);

	while(TRUE)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto DecipherEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szFileToDecipher,hFileToDecipher,
							  lpKeyBuffer1,ENC_BUFFER_SIZE,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecipherEnd;
		}
		if (dwBytesRead == 0)
		{
			break;
		}
		// Accumulate the actual size of the file.
		//........................................
		uliTotalBytes.QuadPart += dwBytesRead;
		if (dwUseSessionKey == USE_PAD)
		{
			ChangeBytesPad(lpKeyBuffer1,dwBytesRead,hOtpKeyFile);
		}
		else
		{
			ChangeBytes(lpKeyBuffer1,dwBytesRead);
		}
		bResult = WriteMyFile((LPTSTR)&szDestination,hDecryptedFile,
							   lpKeyBuffer1,dwBytesRead,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecipherEnd;
		}
	}
	// Flush buffers and rewind the output file.
	//..........................................
	bResult = FlushMyFile((LPTSTR)&szDestination,hDecryptedFile);
	if (!bResult)
	{
		goto DecipherEnd;
	}
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&szDestination,hDecryptedFile,li.QuadPart,
								    FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto DecipherEnd;
	}
	// Set the files date and time.
	//.............................
	bResult = SetFileTime(hDecryptedFile,(LPFILETIME)&fip.CREATION,(LPFILETIME)&fip.ACCESSED,
						 (LPFILETIME)&fip.WRITTEN);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILETIME,MB_OK);
	}
	bResult = CloseMyHandle((LPTSTR)&szDestination,hDecryptedFile);
	if (!bResult)
	{
		goto DecipherEnd;
	}
	hDecryptedFile = 0;

	bResult = SetMyFileAttributes((LPBYTE)&szDestination,fip.ATTRIBUTES);
	if (!bResult)
	{
		goto DecipherEnd;
	}
	// We have a good decrypted file on disk.
	//.......................................
	bDeleteDecryptedFile = FALSE;
	bErr = FALSE;

	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto DecipherEnd;
	}
	// See if the bytes actually read and decrypted equals what
	// was in the packet length field. For information only.
	//.........................................................
	if (uliTotalBytes.QuadPart != uliCkeBytes.QuadPart)
	{
		SetLastError(IDS_DECRYPTEDNOTEQUAL);
		ErrorProcedure((LPTSTR)&szDestination,IDS_WRITE,MB_OK);
	}
	// Mark file decryption as complete.
	//..................................
	CheckDlgButton(hDialogModeLess,IDC_ENCRYPT2,BST_CHECKED);

	// Decrypt the secret key encrypted packet in lpKeyBuffer3.
	//.........................................................
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_ENCRYPT3),TRUE);
	
	ClearAllVariables();

	// Get the rsa algorithm. Get rid of the high order timestamp.
	//............................................................
	__asm
	{
		mov		edi,lpKeyBuffer3
		mov		al,byte ptr [edi+15]
		and		al,0x01
		mov		TempByte,al
	}
	if ((*lpKeyBuffer3 != VERSION_NEW && *lpKeyBuffer3 != VERSION_OLD) ||
		(*(lpKeyBuffer3+1) != SKE_APPEND_LGTH && *(lpKeyBuffer3+1) != SKE_SHA_APPEND_LGTH) ||
		 *(lpKeyBuffer3+2) != SIG_MSG_BINARY ||
		(*(lpKeyBuffer3+16) != MD5_ALGORITHM && *(lpKeyBuffer3+16) != SHA_ALGORITHM &&
		 *(lpKeyBuffer3+16) != SHA512_ALGORITHM) || TempByte != RSA_ALGORITHM)
	{
		SetLastError(IDS_INVALIDSKEPACKET);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherEnd;
	}
	if (*(lpKeyBuffer3+16) == MD5_ALGORITHM)
	{
		dwMd5AppendLength = SKE_APPEND_LGTH;
	}
	else
	{
		dwMd5AppendLength =	SKE_SHA_APPEND_LGTH;
	}
	liSkeTimestamp.QuadPart = 0;
	
	__asm
	{
		mov		edi,lpKeyBuffer3
		add		edi,(VERSION_SIZE+1)
		mov		lpMd5AppendPtr,edi
		inc		edi
		mov		eax,dword ptr [edi]
		bswap	eax
		mov		liSkeTimestamp.LowPart,eax

		// Get the high order 7 bits of the timestamp.
		//............................................
		mov		eax,dword ptr [edi+12]
		and		eax,0x00ff
		shr		eax,1
		mov		liSkeTimestamp.HighPart,eax

		add		edi,TIMESTAMP_SIZE

		// Get the key id so we can find the public key.
		//..............................................
		mov		eax,dword ptr [edi]
		mov		edx,dword ptr [edi+4]
		mov		dword ptr KeySID,eax
		mov		dword ptr KeySID[4],edx
		add		edi,(KEY_ID_SIZE + (2 * ALGORITHM_SIZE))

		// Save the pointer to the 1st two bytes of the md5 or sha digest.
		//................................................................
		mov		lpMd5_2_Ptr,edi

		// Setup the rsa integer to decrypt.
		//..................................
		add		edi,2
		movzx	eax,word ptr [edi]
		add		edi,MPI_PREFIX_SIZE
		xchg	ah,al
		mov		dwRsaIntegerBits,eax
		mov		dwSigBits,eax
		mov		lpTempEDI,edi
	}
	// If the ske integer is too big we have to bail out.
	//...................................................
	if (dwRsaIntegerBits > MAX_BITS)
	{
		SetLastError(IDS_SKEINTEGERTOOBIG);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherEnd;
	}
	__asm
	{
		mov		esi,lpTempEDI
		mov		ecx,dwRsaIntegerBits
		add		ecx,7
		shr		ecx,3
		mov		dwRsaIntegerBytes,ecx
		mov		edi,offset Temp2
		rep		movsb
	}
	CircleSwap((LPBYTE)&Temp2,dwRsaIntegerBytes);

	// Search for the public key to decrypt the rsa integer with.
	//...........................................................
	li.QuadPart = SearchMyFileBinary(lpIndexFile1,&KeySID,KEY_ID_SIZE,hIdxHandle1,0,
								     &KeyIdSearch);
	if (li.QuadPart == -1)
	{
		goto DecipherEnd;
	}
	if (li.QuadPart == 0)
	{
		SetLastError(IDS_NOPUBLICKEYTODECRYPTSKE);
		ErrorProcedure((LPTSTR)lpRingFile1,IDS_READ,MB_OK);
		goto DecipherEnd;
	}
	// We have a public key to decrypt the ske packet with.
	//.....................................................
	dwIdxOffset1 = li.HighPart;
	dwBytesRead = ReadIndex1();
	if (dwBytesRead == -1)
	{
		goto DecipherEnd;
	}
	dwBytesRead = ReadRecord1();
	if (dwBytesRead == -1)
	{
		goto DecipherEnd;
	}

	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto DecipherEnd;
	}
	// Get the user id in case we have a red alert.
	//.............................................
	ZeroMemory(&TempUserId,sizeof(TempUserId));
	lpKeyBufferDup1 = lpKeyBuffer1;

	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,eax
		mov		lpKeyBufferDup1,edi
	}
	// Search for the first user id.
	//..............................
	while(TRUE)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		CtbByte,al
		}
		if (CtbByte != CTB_USER_ID)
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup1,edi
			}
		}
		else
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpKeyBufferDup1,edi
				mov		dwIdLength,eax
			}
			break;
		}
	}
	CopyMemory(&TempUserId,lpKeyBufferDup1,dwIdLength);

	// Display the sender's name.
	//...........................
	__asm
	{
		mov		eax,dword ptr KeySID[4]
		bswap	eax
		mov		dwPubKeyID,eax
	}
	StringCbPrintf(szOutBuffer,sizeof(szOutBuffer),lpszSender,&TempUserId,dwPubKeyID);
	SetDlgItemText(hDialogModeLess,IDC_SENDER,(LPCTSTR)&szOutBuffer);

	liPublicKeyExpire.QuadPart = 0;
	
	// Now setup modulus n and exponet e.
	//...................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		mov		cl,byte ptr [edi]
		add		edi,CTB_SIZE
		mov		edx,1
		and		cl,LENGTH_MASK
		shl		edx,cl
		add		edi,edx
		add		edi,VERSION_SIZE
		mov		ebx,dword ptr [edi]
		bswap	ebx

		// Get the high 7 bits of the timestamp.
		//......................................
		mov		esi,dword ptr [edi+6]
		and		esi,0x00ff
		shr		esi,1

		add		edi,TIMESTAMP_SIZE
		movzx	eax,word ptr [edi]
		xchg	ah,al
		cmp		eax,0
		je		L19
		xor		edx,edx
		mov		ecx,SECS_PER_DAY
		mul		ecx
		add		eax,ebx
		adc		edx,esi
		mov		liPublicKeyExpire.LowPart,eax
		mov		liPublicKeyExpire.HighPart,edx

	  L19:
		add		edi,(VALIDITY_SIZE + ALGORITHM_SIZE)

		// Setup modulus n.
		//.................
		movzx	eax,word ptr [edi]
		add		edi,MPI_PREFIX_SIZE
		xchg	ah,al
		mov		dwN_Bits,eax
		add		eax,7
		shr		eax,3
		mov		dwN_Bytes,eax
		push	edi
		mov		esi,edi
		mov		ecx,eax
		mov		edi,offset Modulus_N
		rep		movsb
		pop		edi
		add		edi,dwN_Bytes

		// Setup exponent e.
		//..................
		movzx	eax,word ptr [edi]
		add		edi,MPI_PREFIX_SIZE
		xchg	ah,al
		add		eax,7
		shr		eax,3
		mov		dwE_Bytes,eax
		mov		lpTempEDI,edi
		mov		esi,edi
		mov		ecx,eax
		mov		edi,offset E_Temp
		rep		movsb
	}
	CircleSwap((LPBYTE)&Modulus_N,dwN_Bytes);
	CircleSwap((LPBYTE)&E_Temp,dwE_Bytes);

	// Check to see if this key is disabled or not. Get the trust
	// packet following the key packet.
	//...........................................................
	__asm
	{
		mov		edi,lpTempEDI
		add		edi,dwE_Bytes
		mov		cl,byte ptr [edi]
		add		edi,CTB_SIZE
		and		cl,LENGTH_MASK
		mov		edx,1
		shr		edx,cl
		add		edi,edx
		mov		lpTempEDI,edi
	}
	if (*lpTempEDI & DISABLED_BIT)
	{
		RedAlert();
	}
	else if (liPublicKeyExpire.QuadPart != 0)
	{
		if (liSkeTimestamp.QuadPart > liPublicKeyExpire.QuadPart)
		{
			RedAlert();
		}
	}
	// Make sure modulus n is greater than the rsa integer.
	//.....................................................
	if (dwRsaIntegerBits > dwN_Bits)
	{
	  RsaIntegerError:
		SetLastError(IDS_RSAINTEGERINSKEGTMODNINPUBKEY);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherFinished;
	}
	// If the bits are equal, compare the actual variables.
	//.....................................................
	if (dwRsaIntegerBits == dwN_Bits)
	{
		dwResult = MpCompareDW((LPBYTE)&Modulus_N,(LPBYTE)&Temp2,MAX_MOD_DWORD);
		if (dwResult != -1)
		{
			goto RsaIntegerError;
		}
	}
	// Decipher the rsa integer.
	//..........................
	bError = RsaPubDec((LPBYTE)&Temp1,(LPBYTE)&Temp2,(LPBYTE)&E_Temp,
					  (LPBYTE)&Modulus_N,dwN_Bytes);
	CheckDlgButton(hDialogModeLess,IDC_ENCRYPT3,BST_CHECKED);

	if (bError)
	{
	  PubDecError:
		SetLastError(IDS_RSAPUBDECFAILED);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_READ,MB_OK);
		goto DecipherFinished;
	}
	// Make sure the size of the returned data is correct.
	//....................................................
	if (dwCountBytes != MD5_DIGEST_SIZE && dwCountBytes != SHA_DIGEST_SIZE &&
		dwCountBytes != SHA512_DIGEST_SIZE)
	{
		goto PubDecError;
	}
	// Store the type of message digest used.
	//.......................................
	dwTypeDigest = SHA512_ENCRYPTED;
	if (dwCountBytes == MD5_DIGEST_SIZE)
	{
		dwTypeDigest = MD_ENCRYPTED;
	}
	else if (dwCountBytes == SHA_DIGEST_SIZE)
	{
		dwTypeDigest = SHA_ENCRYPTED;
	}
	// Check the first 2 bytes of the md5 or sha to see if they match
	// the ones in the ske packet.
	//...............................................................
	if (*lpMd5_2_Ptr != *Temp1 || *(lpMd5_2_Ptr+1) != *(Temp1+1))
	{
		goto PubDecError;
	}
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_ENCRYPT4),TRUE);

	if (dwTypeDigest == MD_ENCRYPTED)
	{
		// Calculate the md5 of the decrypted file.
		//.........................................
		bResult = FileMd5((LPBYTE)&szDestination,(LPBYTE)&Md5ForFile,
						   lpMd5AppendPtr,dwMd5AppendLength);
	}
	else if (dwTypeDigest == SHA_ENCRYPTED)
	{
		bResult = FileSha((LPBYTE)&szDestination,(LPBYTE)&ShaForFile,
						   lpMd5AppendPtr,dwMd5AppendLength);
	}
	else
	{
		bResult = FileSha512((LPBYTE)&szDestination,(LPBYTE)&Sha512ForFile,
							 lpMd5AppendPtr,dwMd5AppendLength);
	}
	if (!bResult)
	{
		iMd5Passed = -1;
	}
	else
	{
		CheckDlgButton(hDialogModeLess,IDC_ENCRYPT4,BST_CHECKED);
		EnableWindow(GetDlgItem(hDialogModeLess,IDC_ENCRYPT5),TRUE);
		
		if (dwTypeDigest == MD_ENCRYPTED)
		{
			// Compare the computed md5 with the md5 in the ske packet.
			//.........................................................
			iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&Temp1,MD5_DIGEST_SIZE,
								   (LPCTSTR)&Md5ForFile,MD5_DIGEST_SIZE);
		}
		else if (dwTypeDigest == SHA_ENCRYPTED)
		{
			// Compare the computed sha1 with the sha1 in the ske packet.
			//...........................................................
			iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&Temp1,SHA_DIGEST_SIZE,
								   (LPCTSTR)&ShaForFile,SHA_DIGEST_SIZE);
		}
		else
		{
			// Compare the computed sha512 with the sha512 in the ske packet.
			//...............................................................
			iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&Temp1,SHA512_DIGEST_SIZE,
								   (LPCTSTR)&Sha512ForFile,SHA512_DIGEST_SIZE);
		}
		if (iResult == CSTR_EQUAL)
		{
			iMd5Passed = 1;
		}
		else
		{
			iMd5Passed = 0;
		}
		CheckDlgButton(hDialogModeLess,IDC_ENCRYPT5,BST_CHECKED);
	}
	// We are done. Setup the final message.
	//......................................
	DecipherFinished:
	if (iMd5Passed == -2)
	{
		uiMd5Result = IDS_MD5NOTDONE;
	}
	else if (iMd5Passed == -1)
	{
		uiMd5Result = IDS_MD5CHKFAILED;
	}
	else if (iMd5Passed == 0)
	{
		uiMd5Result = IDS_MD5NOTPASSED;
	}
	else
	{
		uiMd5Result = IDS_MD5PASSED;
	}
	// If we had an sha message digest, get the sha strings.
	//......................................................
	if (dwTypeDigest == SHA_ENCRYPTED)
	{
		uiMd5Result += 126;
	}
	else if (dwTypeDigest == SHA512_ENCRYPTED)
	{
		uiMd5Result += 255;
	}
	LoadString(hInst,(UINT)uiMd5Result,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,(LPCTSTR)&szOutBuffer);

	// Wipe the section of true one time pad we used.
	//...............................................
	if (dwUseSessionKey == USE_PAD)
	{
		while(TRUE)
		{
			bResult = FALSE;
			liPadFreeBytes.QuadPart = 0;
			liPadFreeBytes.QuadPart = SetMyFilePointer((LPTSTR)&szOtpKeyFile,hOtpKeyFile,
													    liPadFreeBytes.QuadPart,FILE_CURRENT);
			if (liPadFreeBytes.QuadPart == -1)
			{
				SetLastError(IDS_UNABLE_TO_SET_START_POINT);
				ErrorProcedure((LPTSTR)&szOtpKeyFile,IDS_SETFILEPOINTER,MB_OK);
				break;
			}
			li.QuadPart = PAD_ID_SIZE;
			li.QuadPart = SetMyFilePointer((LPTSTR)&szOtpKeyFile,hOtpKeyFile,
										    li.QuadPart,FILE_BEGIN);
			if (li.QuadPart == -1)
			{
				SetLastError(IDS_UNABLE_TO_SET_START_POINT);
				ErrorProcedure((LPTSTR)&szOtpKeyFile,IDS_SETFILEPOINTER,MB_OK);
				break;
			}
			bResult = WriteMyFile((LPTSTR)&szOtpKeyFile,hOtpKeyFile,&liPadFreeBytes.QuadPart,
								   sizeof(LARGE_INTEGER),&dwBytesWritten,NULL);
			if (!bResult)
			{
				SetLastError(IDS_UNABLE_TO_SET_START_POINT);
				ErrorProcedure((LPTSTR)&szOtpKeyFile,IDS_SETFILEPOINTER,MB_OK);
				break;
			}
			break;
		}
		if (bResult && !bDeleteDecryptedFile && (cfg.dwWipeAfterUse || 
			bWipeTrueOTPFileAfterUse))
		{
			bResult = WipePadSection((LPTSTR)&szOtpKeyFile,hOtpKeyFile,
									  liStartPosition.QuadPart,liWipeLength.QuadPart);
			if (!bResult)
			{
				SetLastError(IDS_PADOVERWRITEERROR);
				ErrorProcedure((LPTSTR)&szOtpKeyFile,IDS_WIPEPADSECTION,MB_OK);
			}
		}
	}
	// Clear buffers 1 and 2.
	//.......................
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,ENC_BUFFER_SIZE);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,ENC_BUFFER_SIZE);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	// We are done decrypting the file. Change the cancel button
	// to OK and wait for input.
	//..........................................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}
	// Flash our task bar icon if it is minimized.
	//............................................
	FlashMyIcon(TRUE);

	while(TRUE)
	{
		CheckForMessages();

		if (bCancelOperation == TRUE)
		{
			bCancelOperation = FALSE;
			break;
		}
	}

	DecipherEnd:

	FlashMyIcon(FALSE);

	if (hHook)
	{
		UnhookWindowsHookEx(hHook);
		hHook = 0;
	}
	if (hMouseHook)
	{
		UnhookWindowsHookEx(hMouseHook);
		hMouseHook = 0;
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}
	// Reset the status bar to ready or the name of the key rings.
	//............................................................
	if (bDisplayRingsOnStatusBar)
	{
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szStatusBarRings);
	}
	else
	{
		LoadString(hInst,IDS_READY,szOutBuffer,sizeof(szOutBuffer));
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szOutBuffer);
	}
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	if (lpKeyBuffer3)
	{
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer3);
		lpKeyBuffer3 = 0;
	}
	// Check to see if we need to unpack a packed file.
	//.................................................
	bIntermediatePkd = FALSE;
	
	// If we cancelled out we cannot try to upack a file.
	//...................................................
	if (!bErr)
	{
		CopyMemory(&szFileName,&szDestination,MAX_PATH);
		hInputFile = IsValidPackedFile((LPBYTE)&szFileName,FALSE);
		if (hInputFile)
		{
			// Remove the file name from the destination.
			//...........................................
			PathRemoveFileSpec((LPTSTR)&szDestination);
			bError = UnpackAFile((LPBYTE)&szFileName);
			if (!bError)
			{
				bIntermediatePkd = TRUE;
			}
			else
			{
				// We had an error unpacking the file.
				//....................................
				bDeleteDecryptedFile = TRUE;
			}
		}
	}
	if (hFileToDecipher)
	{
		CloseMyHandle((LPTSTR)&szFileToDecipher,hFileToDecipher);
	}
	if (bWipeAfterDecryption && !bDeleteDecryptedFile && !lpDecryptFile)
	{
		ConfirmWipeMyFile(IDS_CONFIRMDEC,(LPBYTE)&szFileToDecipher,TRUE);
	}
	// Wipe the intermediate packed file if we had one.
	//.................................................
	if (!bError && bIntermediatePkd && bWipeIntermediate)
	{
		WipeMyFile((LPBYTE)&szFileName,TRUE);
	}
	if (hOtpKeyFile)
	{
		CloseMyHandle((LPTSTR)&szOtpKeyFile,hOtpKeyFile);
	}
	// Wipe the OTP Key File if we used one and we want to wipe it.
	//.............................................................
	if (dwUseSessionKey == USE_KEY && !bDeleteDecryptedFile && 
	   (cfg.dwWipeAfterUse || bWipeOTPFileAfterUse))
	{
		ConfirmWipeMyFile(IDS_CONFIRMWIPE,(LPBYTE)&szOtpKeyFile,TRUE);
	}
	if (hDecryptedFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hDecryptedFile);
		if (bDeleteDecryptedFile)
		{
			WipeMyFile((LPBYTE)&szDestination,TRUE);
		}
	}
	ChangeHelpTopic(dwOldHelpTopic);
	bCancelOperation = FALSE;
	ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
	bWipeIntermediate = FALSE;
	if (!lpDecryptFile)
	{
		bProcessInProgress = FALSE;
	}
	return(bDeleteDecryptedFile);
}

// Special hook for open file dialog for decrypting a file.
// Adds a wipe after decryption checkbox.
//.........................................................
UINT CALLBACK MyDecOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam,LPARAM lParam)
{
	static HWND		hWndParent;
	UINT			uCheck;
	LPHELPINFO		lphi;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			CheckDlgButton(hDlg,IDC_WIPEINTERPKD,BST_CHECKED);
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_WIPEAFTERDEC:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPEAFTERDEC);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeAfterDecryption = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeAfterDecryption = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPEAFTERDEC,uCheck);
				}
				break;

				case IDC_WIPEINTERPKD:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPEINTERPKD);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeIntermediate = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeIntermediate = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPEINTERPKD,uCheck);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_WIPEAFTERDEC || lphi->iCtrlId == IDC_WIPEINTERPKD)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}

// Check out the selected file to make sure it is a valid tsc
// encrypted file. Returns -1 if not a valid tsc encrypted file,
// else the file position of the ctb byte for the cke packet
// which is used by the phi and chi tests.
//.............................................................
__int64 IsTscFileValid(LPBYTE lpFileName)
{
	ULARGE_INTEGER	liCke;
	ULARGE_INTEGER	li;
	HANDLE			hTscFile = 0;
	LPBYTE			lpTscBuffer;
	DWORD			dwTempECX;
	DWORD			dwBytesRead;
	DWORD			dwBytesToRead;
	BOOL			bResult;
	DWORD			dwPkePackets = 0;
	DWORD			dwSkePackets = 0;
	DWORD			dwCkePackets = 0;
	DWORD			dwFipPackets = 0;
	BYTE			CtbType;

	liCke.QuadPart = -1;

	// Allocate the memory for the buffer.
	//....................................
	lpTscBuffer = AllocateMemory(64);
	if (!lpTscBuffer)
	{
		goto IsValidEnd;
	}
	// Open the file.
	//...............
	hTscFile = CreateMyFile((LPTSTR)lpFileName,GENERIC_READ,0,NULL,
						     OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hTscFile)
	{
		goto IsValidEnd;
	}
	// Go into a loop and check out the file.
	//.......................................
	while(TRUE)
	{
		// Read a CTB byte.
		//.................
		bResult = ReadMyFile((LPTSTR)lpFileName,hTscFile,lpTscBuffer,1,&dwBytesRead,NULL);
		if (!bResult)
		{
		  TscError:
			liCke.QuadPart = -1;
			goto IsValidEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Check out the CTB byte.
		//........................
		__asm
		{
			mov		edi,lpTscBuffer
			mov		al,byte ptr [edi]
			movzx	ecx,al
			and		al,CTB_MASK
			mov		CtbType,al
			mov		dwTempECX,ecx
		}
		if (CtbType != CTB_PKE_PACKET && CtbType != CTB_SKE_PACKET &&
			CtbType != CTB_CKE_PCKT && CtbType != CTB_FILE_INFO)
		{
			goto TscError;
		}
		// If this is the CKE packet, get the pointer to its CTB byte.
		//............................................................
		if (CtbType == CTB_CKE_PCKT)
		{
			liCke.QuadPart = 0;
			liCke.QuadPart = SetMyFilePointer((LPTSTR)lpFileName,hTscFile,
											   liCke.QuadPart,FILE_CURRENT);
			if (liCke.QuadPart == -1)
			{
				goto IsValidEnd;
			}
			liCke.QuadPart--;
			dwCkePackets++;
		}
		// Determine the length of the length field and read it.
		//......................................................
		__asm
		{
			mov		edx,1
			mov		ecx,dwTempECX
			and		cl,LENGTH_MASK
			shl		edx,cl
			mov		dwBytesToRead,edx
		}
		bResult = ReadMyFile((LPTSTR)lpFileName,hTscFile,lpTscBuffer,
							  dwBytesToRead,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto TscError;
		}
		if (dwBytesToRead != dwBytesRead)
		{
			goto TscError;
		}
		// Get the length of this packet.
		//...............................
		li.QuadPart = 0;
		__asm
		{
			mov		edi,lpTscBuffer
			cmp		dwBytesToRead,1
			jne		L1
			movzx	eax,byte ptr [edi]
			mov		li.LowPart,eax
			jmp		L4
		L1:	cmp		dwBytesToRead,2
			jne		L2
			movzx	eax,word ptr [edi]
			xchg	ah,al
			mov		li.LowPart,eax
			jmp		L4
		L2:	cmp		dwBytesToRead,4
			jne		L3
			mov		eax,dword ptr [edi]
			bswap	eax
			mov		li.LowPart,eax
			jmp		L4
		L3:
		}
		CircleSwap(lpTscBuffer,8);
		CopyMemory(&li.QuadPart,lpTscBuffer,8);

		// Make sure the packet sizes are within limits.
		//..............................................
		L4:

		if (CtbType == CTB_PKE_PACKET)
		{
			dwPkePackets++;
			if (li.QuadPart > (MAX_PKE_SIZE - 3))
			{
				goto TscError;
			}
		}
		else if (CtbType == CTB_SKE_PACKET)
		{
			dwSkePackets++;
			if (li.QuadPart > (MAX_SIG_SIZE - 3))
			{
				goto TscError;
			}
		}
		else if (CtbType == CTB_FILE_INFO)
		{
			dwFipPackets++;
			if (li.QuadPart > sizeof(FILE_INFO_PCKT) - 3)
			{
				goto TscError;
			}
		}
		// Move to the end of this packet.
		//................................
		li.QuadPart = SetMyFilePointer((LPTSTR)lpFileName,hTscFile,li.QuadPart,FILE_CURRENT);
		if (li.QuadPart == -1)
		{
			goto TscError;
		}
	}
	// See if we have the correct number and type of packets in the
	// file to be a tsc encrypted file.
	//..............................................................
	if (dwPkePackets == 0 || dwSkePackets != 1 || dwCkePackets != 1 ||
		dwFipPackets != 1)
	{
		goto TscError;
	}

	IsValidEnd:

	if (lpTscBuffer)
	{
		DeallocateMemory(lpTscBuffer);
	}
	if (hTscFile)
	{
		CloseMyHandle((LPTSTR)lpFileName,hTscFile);
	}
	return(liCke.QuadPart);
}

// CALLBACK procedure for the decrypt pke packet dialog box.
//..........................................................
LRESULT CALLBACK DecryptPkePacketProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			SetBoldFont(hDlg,IDC_MESSAGE,0);

			// Setup the name of the file to decipher.
			//........................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileToDecipher));

			// Setup the name of the key owner.
			//.................................
			SetDlgItemTextFmt(hDlg,IDC_RECIPIENT,(LPCTSTR)&TempUserId);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for the file decryption dialog box.
//.......................................................
LRESULT CALLBACK DecryptAFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			TCHAR		szBuffer[128];

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetBoldFont(hDlg,IDC_MESSAGE,0);

			// Find the icon of the file we are decrypting.
			//.............................................
			hIcon = FindMyIcon((LPBYTE)&szDestination,lpDestExtension);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{	
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
			}
			// Setup the name of the file to decipher.
			//........................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileToDecipher));

			// Setup the name of the decrypted file.
			//......................................
			SetDlgItemTextFmt(hDlg,IDC_FILE2,
						     (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			// Change the Md5 to Sha1 or Sha512 if required.
			//..............................................
			if (bWeHaveSha)
			{
				if (bWeHaveSha512)
				{
					LoadString(hInst,IDS_DC_CAL_SHA512,(LPTSTR)&szBuffer,sizeof(szBuffer));
					SetWindowText(GetDlgItem(hDlg,IDC_ENCRYPT4),(LPCTSTR)&szBuffer);
					LoadString(hInst,IDS_DC_CHECK_SHA512,(LPTSTR)&szBuffer,sizeof(szBuffer));
					SetWindowText(GetDlgItem(hDlg,IDC_ENCRYPT5),(LPCTSTR)&szBuffer);
				}
				else
				{
					LoadString(hInst,IDS_DEC_CAL_SHA,(LPTSTR)&szBuffer,sizeof(szBuffer));
					SetWindowText(GetDlgItem(hDlg,IDC_ENCRYPT4),(LPCTSTR)&szBuffer);
					LoadString(hInst,IDS_DEC_CHECK_SHA,(LPTSTR)&szBuffer,sizeof(szBuffer));
					SetWindowText(GetDlgItem(hDlg,IDC_ENCRYPT5),(LPCTSTR)&szBuffer);
				}
			}
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for asking confirmation on overwriting
// the file with the one we are about to decrypt.
//........................................................
LRESULT CALLBACK ConfirmOverWriteDecProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			LARGE_INTEGER		li;
			WIN32_FIND_DATA		FindData;
			TCHAR				szInBuffer[332];
			TCHAR				szFormatedNumber[64];
			HANDLE				hSearchHandle;
			FILETIME			ftLocalTime;
			SYSTEMTIME			stLocalTime;
			TCHAR				szLocalDate[128];
			TCHAR				szLocalTime[64];

			// Clear a few variables.
			//.......................
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			ZeroMemory(&szLocalDate,sizeof(szLocalDate));
			ZeroMemory(&szLocalTime,sizeof(szLocalTime));
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the dialog box.
			//......................
			SetDlgItemTextFmt(hDlg,IDC_CONTAINS,
						     (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			// Let find the icon for the file.
			//................................
			hIcon = FindMyIcon((LPBYTE)&szDestination,lpDestExtension);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
				SendMessage(GetDlgItem(hDlg,IDC_ICON2),STM_SETICON,(WPARAM)hIcon,0);
			}
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the file information for each file.
			// Do the destination file first.
			//..........................................
			hSearchHandle = FindFirstFile((LPCTSTR)&szDestination,&FindData);
			FindClose(hSearchHandle);
			li.LowPart = FindData.nFileSizeLow;
			li.HighPart = FindData.nFileSizeHigh;
			_i64toa(li.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZE1,(LPCTSTR)szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Now do the time and date.
			//..........................
			FileTimeToLocalFileTime((LPFILETIME)&FindData.ftLastWriteTime,
									(LPFILETIME)&ftLocalTime);
			FileTimeToSystemTime((LPFILETIME)&ftLocalTime,(LPSYSTEMTIME)&stLocalTime);
			// Format the date.
			//.................
			GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&stLocalTime,
				          NULL,(LPTSTR)&szLocalDate,sizeof(szLocalDate));

			// Format the time.
			//.................
			GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,
						  &stLocalTime,NULL,(LPTSTR)&szLocalTime,sizeof(szLocalTime));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDateTimeFormat,&szLocalDate,
						   &szLocalTime);
			SetDlgItemText(hDlg,IDC_DATETIME1,(LPCTSTR)szInBuffer);

			// Clear a few variables.
			//.......................
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			ZeroMemory(&szLocalDate,sizeof(szLocalDate));
			ZeroMemory(&szLocalTime,sizeof(szLocalTime));
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the information for the source file.
			//...........................................
			_ui64toa(uliCkeBytes.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZE2,(LPCTSTR)szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Now do the time and date.
			//..........................
			FileTimeToLocalFileTime((LPFILETIME)&fip.WRITTEN,(LPFILETIME)&ftLocalTime);
			FileTimeToSystemTime((LPFILETIME)&ftLocalTime,(LPSYSTEMTIME)&stLocalTime);
			// Format the date.
			//.................
			GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&stLocalTime,
				          NULL,(LPTSTR)&szLocalDate,sizeof(szLocalDate));

			// Format the time.
			//.................
			GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,
						  &stLocalTime,NULL,(LPTSTR)&szLocalTime,sizeof(szLocalTime));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDateTimeFormat,&szLocalDate,
						   &szLocalTime);
			SetDlgItemText(hDlg,IDC_DATETIME2,(LPCTSTR)szInBuffer);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{

				case IDC_MYYESDEC:
				{
					EndDialog(hDlg,IDC_MYYESDEC);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// Red Alert procedure.
//.....................
VOID RedAlert()
{
	TCHAR		szFormat[512];
	TCHAR		szOutBuffer[1024];

	LoadString(hInst,IDS_REDALERTFMT,(LPTSTR)&szFormat,sizeof(szFormat));
	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFormat,TempUserId);
	MessageBoxProc(hMainWindow,IDS_REDALERT,(UINT)szOutBuffer,
				   MB_OK | MB_ICONHAND,MB_ICONHAND,0);
}

// Dialog box for displaying special instruction when deciphering a file.							   
//.......................................................................
LRESULT CALLBACK PutSpecialInstructionsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, 
											LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			SetBoldFont(hDlg,IDC_PUTSPECIAL,0);

			// Setup the name of the file to decipher.
			//........................................
			SetDlgItemTextFmt(hDlg,IDC_STATEMENT1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileToDecipher));

			// Display our message or classification.
			//.......................................
			SetDlgItemText(hDlg,IDC_PUTSPECIAL,(LPCTSTR)&fip.INSTRUCTIONS);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDOK));
			return(FALSE);
		}

		case WM_CTLCOLOREDIT:
		{
			SetTextColor((HDC)wParam,crClassification);
			SetBkColor((HDC)wParam,RGB(255,255,255));
			return((BOOL)GetStockObject(WHITE_BRUSH));
		}
		break;

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					if (hDlgFont)
					{
						DeleteObject(hDlgFont);
						hDlgFont = 0;
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					if (hDlgFont)
					{
						DeleteObject(hDlgFont);
						hDlgFont = 0;
					}
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}
